//
// Created by bh on 2022/12/15.
//

#include "stdio.h"
#include "malloc.h"
#include "string.h"

// 单向队列
// 设计思路：新建一个双向不循环链表，所有元素在队尾插入，从队头取出，取出后的元素从队列中删除

typedef struct queue{
    int len;
    char name[10];
    struct queue * prev;
    struct queue * next;
}Queue;
// 创建队列节点
Queue * create (){
    return (Queue *) malloc(sizeof (Queue));
}

// 入队，尾部加入
void enqueue(Queue * headQ,Queue * newQ){
    Queue * nextQ = headQ;
    while (nextQ->next){
        nextQ = nextQ->next;
    }
    nextQ->next = newQ;

    newQ->next = NULL;
    newQ->prev = nextQ;

}
// 出队，头部出队，下一个节点变为头部
Queue * dequeue(Queue * headQ){
    Queue * quitQ = (Queue *) malloc(sizeof(Queue));
    if(headQ->next == NULL){  // 队列只有一个节点
        memcpy(quitQ,headQ, sizeof(Queue));
        free(headQ);
    } else{ // 队列有多个节点
        Queue * newHead = headQ->next;
        memcpy(quitQ,headQ, sizeof(Queue));
        headQ->next->prev=NULL;
        headQ->next = NULL;
        memcpy(headQ,newHead, sizeof(Queue));
    }

    return quitQ;
}
// 打印队列
void printQueue(Queue * headQ){
    Queue * nextQ = headQ;
    while (nextQ->next){
        printf("name=%s,len=%d,prev=%p,address=%p,next=%p\n",nextQ->name,nextQ->len,nextQ->prev,nextQ,nextQ->next);
        nextQ=nextQ->next;
    }
    printf("name=%s,len=%d,prev=%p,address=%p,next=%p\n",nextQ->name,nextQ->len,nextQ->prev,nextQ,nextQ->next);
}

int main()
{
    Queue * headQ = create();
    headQ->len = 1;
    headQ->next = NULL;
    headQ->prev = NULL;
    memcpy(headQ->name,"headQ", strlen("headQ"));

    Queue * q1 = create();
    strcpy(q1->name,"q1");
    enqueue(headQ,q1);

    Queue * q2 = create();
    strcpy(q2->name,"q2");
    enqueue(headQ,q2);

    Queue * q3 = create();
    strcpy(q3->name,"q3");
    enqueue(headQ,q3);

    Queue * q4 = create();
    strcpy(q4->name,"q4");
    enqueue(headQ,q4);

    printQueue(headQ);

    Queue * quitQ1  = dequeue(headQ);
    printf("===========================\n");
    printf("quit Q====name=%s,len=%d,prev=%p,address=%p,next=%p\n",quitQ1->name,quitQ1->len,quitQ1->prev,quitQ1,quitQ1->next);
    printf("new head====name=%s,len=%d,prev=%p,address=%p,next=%p\n",headQ->name,headQ->len,headQ->prev,headQ,headQ->next);

    printf("===========================\n");
    printQueue(headQ);


    Queue * quitQ2  = dequeue(headQ);
    printf("===========================\n");
    printf("quit Q====name=%s,len=%d,prev=%p,address=%p,next=%p\n",quitQ2->name,quitQ2->len,quitQ2->prev,quitQ2,quitQ2->next);
    printf("new head====name=%s,len=%d,prev=%p,address=%p,next=%p\n",headQ->name,headQ->len,headQ->prev,headQ,headQ->next);

    printf("===========================\n");
    printQueue(headQ);

    return 0;
}


