//
// Created by bh-1 on 2022/12/14.
//

#include "stdio.h"
#include "malloc.h"
#include "string.h"
// 单向循环链表
typedef struct node{
    int len;
    char name[10];
    struct node * next;
}Node;
// 申请节点内存
Node * create(){
    return (Node *) malloc(sizeof (Node));
}
Node * initNode(){
    Node * head = create();
    head->len = 0;
    strcpy(head->name,"head");
    head->next = head;
    head->len++;
    return head;
}
// 获取循环链表的长度
int linkLen(Node * head){
    int len = 1;
    Node * nextNode = head;
    while (nextNode->next != head){
        len++;
        nextNode = nextNode->next;
    }
    return len;
}
// 插入一个链表
void insert(Node * head,Node * newNode){
    if(head->next == head){ // 只有一个头节点
        head->next = newNode;
        newNode->next= head;
    } else{  // 超过2个节点
        Node * nextNode;
        nextNode = head;
        while (nextNode->next != head){
            nextNode=nextNode->next;
        }
        nextNode->next = newNode;
        newNode->next = head;
    }
    head->len++;
}

// 随机节点地址插入
void randInsert(Node * beforeNode,Node * newNode){
   if(linkLen(beforeNode) == 1 ){  // 只有一个节点，那就只能是头节点
       newNode->next = beforeNode;
       beforeNode->next = newNode;
   } else{  // 多个节点
       newNode->next = beforeNode->next;
       beforeNode->next = newNode;
   }
}

// 删除一个节点
void delNode(Node * head,Node * delNode){
    if((linkLen(head) == 1) || (delNode->name == head->name)){  // 不删除头节点
        printf("don't delete head node");
        return;
    }
    Node * nextNode;
    Node * thisNode;
    nextNode = head;
    while (nextNode->next != head){
        thisNode = nextNode;
        nextNode = nextNode->next;
        if(nextNode->name == delNode->name){
            thisNode->next = nextNode->next;
            free(nextNode);
            head->len--;
        }
        nextNode = thisNode;
    }
}

void printList(Node * head){
    Node * nextNode;
    nextNode = head;
    while (nextNode->next != head){
        printf("name=%s,len=%d,address=%p,next=%p\n",nextNode->name,nextNode->len,nextNode,nextNode->next);
        nextNode = nextNode->next;
    }
    printf("name=%s,len=%d,address=%p,next=%p\n",nextNode->name,nextNode->len,nextNode,nextNode->next);
}


int main(){
    Node * head = initNode();

    Node * node1 = create();
    strcpy(node1->name,"node1");
    insert(head,node1);

    Node * node2 = create();
    strcpy(node2->name,"node2");
    insert(head,node2);

    Node * node3 = create();
    strcpy(node3->name,"node3");
    insert(head,node3);

    Node * node4 = create();
    strcpy(node4->name,"node4");
    insert(head,node4);

    printList(head);

    printf("=====================\n");

    Node * node5 = create();
    strcpy(node5->name,"node5");

    randInsert(node2,node5);

    printList(head);

    return 0;
}









