//
// Created by bh-1 on 2022/12/14.
//

#include "stdio.h"
#include "string.h"
#include "malloc.h"

// 双向不循环链表的设计
typedef struct node{
    int len;
    char name[10];
    struct node * next;
    struct node * prev;
}Node;

// 获取链表长度
int linkLen(Node * node){
    int i=1;
    while (node->next != NULL){
        i++;
        node = node->next;
    }
    return i;
}
// 申请节点空间
Node * create(){
    return (Node *) malloc(sizeof(Node));
}
// 初始化头节点
Node * initHead(){
    Node * head = create();
    head->len = 0;
    strcpy(head->name,"header");
    head->next = NULL;
    head->prev = NULL;
    return head;
}

// 链表头部插入，并返回新的头节点
Node * headInsert(Node * head,Node * newNode){
    Node * newHead = newNode;
    head->prev = newHead;

    newHead->next = head;
    newHead->prev=NULL;
    newHead->len = head->len++;

    head->len = 0;
    return newHead;
}

// 尾部插入节点
void endInsert(Node * head,Node * newNode){
    Node * nextNode = head;
    while (nextNode->next != NULL){
        nextNode = nextNode->next;
    }
    nextNode->next=newNode;
    newNode->prev=nextNode;
    newNode->next=NULL;

    head->len++;
}

Node * delNode(Node * head,Node * delNode){
    if(linkLen(head) == 1){
        printf("only one head node !");
        return head;
    }
    if(delNode == head){  // 删除的节点是头节点
        Node * newHead;
        head->next->prev= NULL;
        newHead = head->next;
        free(head);
        return newHead;
    }
    Node *nextNode = head;
    while (nextNode->next) {
        nextNode = nextNode->next;
        if (nextNode->name == delNode->name) {
            if (nextNode->next == NULL) {  // 要删除的是最后一个节点
                nextNode->prev->next = NULL;
                free(nextNode);
                break;
            } else{  // 不是头节点，也不是尾节点
                nextNode->prev->next = nextNode->next;
                nextNode->next->prev = nextNode->prev;
                free(nextNode);
                break;
            }

        }

    }

    return head;

}

void printLinkList(Node * head){
    Node * nextNode = head;
    while (nextNode->next){
        printf("name=%s,len=%d,prev=%p,address=%p,next=%p\n",nextNode->name,nextNode->len,nextNode->prev,nextNode,nextNode->next);
        nextNode = nextNode->next;
    }
    printf("name=%s,len=%d,prev=%p,address=%p,next=%p\n",nextNode->name,nextNode->len,nextNode->prev,nextNode,nextNode->next);
}


int main()
{
    Node * head = initHead();

    Node * node1 = create();
    strcpy(node1->name,"node1");
    head = headInsert(head,node1);

    Node * node2 = create();
    strcpy(node2->name,"node2");
    head = headInsert(head,node2);

    Node * node3 = create();
    strcpy(node3->name,"node3");
    head = headInsert(head,node3);

    Node * node4 = create();
    strcpy(node4->name,"node4");
    head = headInsert(head,node4);

    Node * node5 = create();
    strcpy(node5->name,"node5");
    endInsert(head,node5);

    Node * node6 = create();
    strcpy(node6->name,"node6");
    endInsert(head,node6);

    Node * node7 = create();
    strcpy(node7->name,"node7");
    endInsert(head,node7);

    Node * node8 = create();
    strcpy(node8->name,"node8");
    endInsert(head,node8);

    printLinkList(head);
    printf("-----------------------\n");
    head = delNode(head,node6);
    printLinkList(head);

    return 0;
}


