//
// Created by bh-1 on 2022/12/14.
//

#include "stdio.h"
#include "malloc.h"
#include "string.h"

// 栈，先进后出
typedef struct stack{
    int len;
    char name[10];
    struct stack * next;
    struct stack * prev;
}Stack;

Stack * create(){
    return (Stack *) malloc(sizeof(Stack));
}

// 入栈
// 思路：先进后出。对于单向不循环链式结构来说，应该在链头插入，然后从头开始往尾读取
void enStack(Stack * bottom,Stack * newMen){
    Stack * upMem = bottom;
    while (upMem->prev){
        upMem=upMem->prev;  // 获取最后入栈的一个节点
    }
    // 向最后一个入栈的节点（栈顶）前面追加newMen
    newMen->prev = NULL;
    newMen->next = upMem;

    upMem->prev = newMen;

    bottom->len++;

}

// 出栈
Stack * deStack(Stack * bottom){
    Stack * upMem = bottom;
    while (upMem->prev){
        upMem=upMem->prev;
    }

    Stack * deStack = (Stack *) malloc(sizeof (Stack));
    /*deStack->len=upMem->len;
    strcpy(deStack->name,upMem->name);
    deStack->prev=upMem->prev;
    deStack->next=upMem->next;*/
    memcpy(deStack,upMem, sizeof(Stack));  // 复制结构体

    upMem->next->prev = NULL;
    free(upMem);

    bottom->len--;
    return deStack;
}
// 从栈顶开始打印到栈底
void printStackList(Stack * bottom){
    Stack * upMen = bottom;
    while (upMen->prev){
        upMen = upMen->prev;
    }
    while (upMen->next){
        printf("name=%s,len=%d,upMen=%p,mem=%p,downMem=%p\n",upMen->name,upMen->len,upMen->prev,upMen,upMen->next);
        upMen=upMen->next;
    }
    printf("name=%s,len=%d,upMen=%p,mem=%p,downMem=%p\n",upMen->name,upMen->len,upMen->prev,upMen,upMen->next);
}

int main()
{
    Stack * bottom = create();
    strcpy(bottom->name,"bottom");
    bottom->len = 0;
    bottom->prev = NULL;
    bottom->next = NULL;
    bottom->len++;

    Stack * men1 = create();
    strcpy(men1->name,"mem1");
    enStack(bottom,men1);

    Stack * men2 = create();
    strcpy(men2->name,"men2");
    enStack(bottom,men2);

    Stack * men3 = create();
    strcpy(men3->name,"men3");
    enStack(bottom,men3);

    Stack * men4 = create();
    strcpy(men4->name,"men4");
    enStack(bottom,men4);

    printStackList(bottom);

    Stack * outMen1 = deStack(bottom);
    printf("========出栈数据：======\n");
    printf("name=%s,len=%d,upMen=%p,mem=%p,downMem=%p\n",outMen1->name,outMen1->len,outMen1->prev,outMen1,outMen1->next);

    printf("========出栈后剩余数据============\n");
    printStackList(bottom);

    Stack * outMen2 = deStack(bottom);
    printf("========出栈数据：======\n");
    printf("name=%s,len=%d,upMen=%p,mem=%p,downMem=%p\n",outMen2->name,outMen2->len,outMen2->prev,outMen2,outMen2->next);

    printf("========出栈后剩余数据============\n");
    printStackList(bottom);

    return 0;
}

