//
// Created by bh on 22-12-13.
//
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>

struct node {
    char name[10];
    int age;
    struct node *prev;
    struct node *next;
};

// create an empty node
struct node *create() {
    struct node *node = (struct node *) malloc(sizeof(struct node));
    if (node == NULL) {
        perror("malloc node failed!");
        exit(1);
    }
    return node;
}


// insert new node
void insertNode(struct node *prevNode, struct node *newNode) {
    if (prevNode->prev != NULL && prevNode->next != NULL) {
        if ((prevNode->next == prevNode->prev) && (prevNode->next == prevNode)) { // if only head
            struct node *head = prevNode;

            prevNode->prev = newNode;
            prevNode->next = newNode;

            newNode->prev = head;
            newNode->next = head;
        } else { // not only head node
            struct node *nextNode = prevNode->next;

            prevNode->next = newNode;

            newNode->prev = prevNode;
            newNode->next = nextNode;

            nextNode->prev = newNode;

        }

    }
}

// delete a node
void delNode(struct node *delNode) {
    struct node *preNode = delNode->prev;
    struct node *nextNode = delNode->next;

    preNode->next = nextNode;
    nextNode->prev = preNode;

    free(delNode);
    delNode = NULL;
}
// print node list
void printChain(struct node *head) {
    struct node *nextNode;
    nextNode = head;
    printf("name=%s,age=%d,===prev=%p,this=%p,next=%p \n", nextNode->name, nextNode->age, nextNode->prev, nextNode,
           nextNode->next);
    while (nextNode->next != head) {
        nextNode = nextNode->next;
        printf("name=%s,age=%d,===prev=%p,this=%p,next=%p \n", nextNode->name, nextNode->age, nextNode->prev, nextNode,
               nextNode->next);
    }

}

int main() {

    struct node *head = create();
    head->age = 10;
    strcpy(head->name, "node0");
    head->next = head;
    head->prev = head;

    struct node *node1 = create();
    node1->age = 18;
    strcpy(node1->name, "node1");
    insertNode(head, node1);

    struct node *node2 = create();
    node2->age = 19;
    strcpy(node2->name, "node2");
    insertNode(node1, node2);

    struct node *node3 = create();
    node3->age = 20;
    strcpy(node3->name, "node3");
    insertNode(node2, node3);

    struct node *node4 = create();
    node4->age = 21;
    strcpy(node4->name, "node4");
    insertNode(node1, node4);

    struct node *node5 = create();
    node5->age = 21;
    strcpy(node5->name, "node5");
    insertNode(node2, node5);

    printChain(head);

    printf("===================================\n");

    delNode(node2);

    printChain(head);
    return 0;
}



