//
// Created by bh on 22-12-13.
//
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

struct node {
    int data;
    struct node * next;
    char name[2];
};

void printNode(struct node * node){
    printf("sizeof node = %lu \n",sizeof (struct node *));
    struct node * nextNode;
    nextNode = node;
    while (nextNode->next != NULL){
        nextNode = nextNode->next;
        printf("name=%s,next=%p,data=%d\n",nextNode->name,nextNode->next,nextNode->data);

    }
}

// create an empty node
struct node * create(){
    struct node * node = (struct node *)malloc(sizeof (struct node));
    if(node ==NULL){
        perror("malloc failed!");
        exit(1);
    }
    return node;
}
// add a node
void insertNode(struct node * endNode,struct node * new){
    if(endNode->next == NULL){
        endNode->next = new->next;
    }
}
// free a node
void freeNode(struct node * node){
    if(NULL != node){
        free(node);
        node = NULL;
    }
    return;
}
// delete a node
void delNode(struct node * prevNode,struct node * deleteNode){
    if(deleteNode->next == NULL){
        prevNode->next = NULL;
    } else{
        prevNode->next = deleteNode->next;
    }
    freeNode(deleteNode);
}
// update node
void updateNode(struct node * prevNode,struct node * updateNode){
    if(prevNode->next == NULL){  // endNode
        updateNode->next = NULL;
        insertNode(prevNode,updateNode);
    } else{
        if(updateNode->next == NULL){
            // todo free all the end of prevNode's nodes
        } else{
            prevNode->next->data = updateNode->data;
            strcpy(prevNode->next->name,updateNode->name);
            prevNode->next->next = updateNode->next;
        }
    }
}

int main ()
{
    struct node * header = create();
    struct node * node1 = create();
//    strcpy(node1->name,"123456789");
    memcpy(node1->name,"123456789",sizeof (node1->name));
    node1->data= 1;
    header->next=node1;

    struct node * node2 = create();
    strcpy(node2->name,"22");
    node2->data=2;
    node1->next=node2;

    struct node * node3  = create();
    strcpy(node3->name,"33");
    node3->data=3;
    node2->next=node3;

    struct node * node4  = create();
    strcpy(node4->name,"44");
    node4->data=4;
    node3->next=node4;

    node4->next = NULL;

    insertNode(header,node1);
    insertNode(node1,node2);
    insertNode(node2,node3);
    insertNode(node3,node4);

    printNode(header);

    delNode(node2,node3);
    printNode(header);

    struct node * node41 = create();
    strcpy(node41->name,"node41");
    node41->data = 41;
    node41->next = NULL;
    updateNode(node3,node41);

    printNode(header);

}

