#include <stdio.h>
#include <malloc.h>
#include <string.h>

// 单向链表的设计
typedef struct node{
	int len;
	char name[10];
	struct node * next;
}Node;

Node * create(){
    return (Node *)malloc(sizeof(Node));
}

Node * initNode(){
    Node * node = create();
	node->len = 0;
	strcpy(node->name,"node0");
	node->next = NULL;
	return node;
}
//
void headInsert(Node * head,Node * newNode){
    Node * headNext = head->next;
    head->next = newNode;
    head->next->next = headNext;
    head->len++;
}

void endInsert(Node * head,Node * newNode){
    Node * nextNode = head;
	while(nextNode->next){
		nextNode = nextNode->next;
	}
	nextNode->next = newNode;

	newNode->next = NULL;

	head->len++;
}

void delNode(Node * head,char name[10]){
    Node * nextNode ;
	nextNode = head;
	while(nextNode->next){
		if(nextNode->name == name){
			nextNode->next = nextNode->next->next;
			free(nextNode->next);
			head->len--;
			break;
		}
	}
}

void printNode(Node * head){
    Node * nextNode;
    nextNode = head;
    printf("name=%s,len=%d, address=%p,next=%p\n",nextNode->name,nextNode->len,nextNode,nextNode->next);
    while(nextNode->next){
        nextNode=nextNode->next;
        printf("name=%s,len=%d, address=%p,next=%p\n",nextNode->name,nextNode->len,nextNode,nextNode->next);
    }

}

int main()
{
    Node * head = initNode();
    Node * node1 = create();
	strcpy(node1->name,"node1");
	headInsert(head,node1);

    Node * node2 = create();
	strcpy(node2->name,"node2");
	headInsert(head,node2);

    Node * node3 = create();
	strcpy(node3->name,"node3");
	headInsert(head,node3);

    Node * node4 = create();
    strcpy(node4->name,"node4");
    endInsert(head,node4);

    Node * node5 = create();
    strcpy(node5->name,"node5");
    endInsert(head,node5);

    Node * node6 = create();
    strcpy(node6->name,"node6");
    endInsert(head,node6);

	printNode(head);

    printf("");


	return 0;

}












