#include <stdio.h>
#include <malloc.h>
#include <string.h>

// 单向链表的设计
// 节点结构体
typedef struct node{
	int len;  // 头节点中使用，保存链表的总长度（不含头节点）
	char name[10];
	struct node * next;
}Node;
// 申请一个节点的空间
Node * create(){
    return (Node *)malloc(sizeof(Node));
}
// 初始化一个节点
Node * initNode(){
    Node * node = create();
	node->len = 0;
	strcpy(node->name,"header");
	node->next = NULL;
	return node;
}
// 头部插入数据
void headInsert(Node * head,Node * newNode){
    Node * headNext = head->next;
    head->next = newNode;
    head->next->next = headNext;
    head->len++;
}
// 尾部插入数据
void endInsert(Node * head,Node * newNode){
    Node * nextNode = head;
	while(nextNode->next){
		nextNode = nextNode->next;
	}
	nextNode->next = newNode;

	newNode->next = NULL;

	head->len++;
}
// 删除一个节点，根据node->name去匹配对应的节点
void delNode(Node * head,Node * delNode){
    if(head->name == delNode->name){  // 头节点，直接返回
        printf("don't delete head node!\n");
        return;
    } else if(head->next){  // 非头节点，继续走
        Node * nextNode;
        Node * thisNode;
        nextNode = head;
        while (nextNode->next){  //
            thisNode=nextNode;
            nextNode=nextNode->next;
            if(nextNode->name == delNode->name){
                if(nextNode->next == NULL){ // 要删除的是最后一个节点
                    thisNode->next = NULL;
                    free(nextNode);
                } else{  // 要删除的不是最后一个节点
                    thisNode->next = nextNode->next;
                    free(nextNode);
                    nextNode = thisNode->next;
                }
            }
        }
    }

}

void printNode(Node * head){
    Node * nextNode;
    nextNode = head;
    printf("name=%s,len=%d, address=%p,next=%p\n",nextNode->name,nextNode->len,nextNode,nextNode->next);
    while(nextNode->next){
        nextNode=nextNode->next;
        printf("name=%s,len=%d, address=%p,next=%p\n",nextNode->name,nextNode->len,nextNode,nextNode->next);
    }

}

int main()
{
    Node * head = initNode();
    Node * node1 = create();
	strcpy(node1->name,"node1");
	headInsert(head,node1);

    Node * node2 = create();
	strcpy(node2->name,"node2");
	headInsert(head,node2);

    Node * node3 = create();
	strcpy(node3->name,"node3");
	headInsert(head,node3);

    Node * node4 = create();
    strcpy(node4->name,"node4");
    endInsert(head,node4);

    Node * node5 = create();
    strcpy(node5->name,"node5");
    endInsert(head,node5);

    Node * node6 = create();
    strcpy(node6->name,"node6");
    endInsert(head,node6);

	printNode(head);

    printf("=========del================\n");

    delNode(head,head);

    printNode(head);
	return 0;

}

