//
// Created by zxsh-1 on 2022/12/14.
//
#include "stdio.h"
#include "string.h"
#include "malloc.h"

// 双向循环链表
typedef struct node{
    int len;
    char name[10];
    struct node * next;
    struct node * prev;
}Node;

Node * create(){
    return (Node *) malloc(sizeof(Node));
}
// 获取链表的长度
int listLen(Node * node){
    int i=1;
    Node * nextNode = node;
    while (nextNode->next != node){
        i++;
        nextNode = nextNode->next;
    }
    return i;
}

Node * initNode(){
    Node * head = create();
    head->len=0;
    strcpy(head->name,"header");
    head->next=head;
    head->prev=head;
    return head;
}

void addNode(Node * head,Node * newNode) {
    if (listLen(head) == 1) {
        head->next = newNode;
        head->prev = newNode;

        newNode->next = head;
        newNode->prev = head;
    } else {
        newNode->prev = head;
        newNode->next = head->next;

        head->next->prev = newNode;
        head->next = newNode;
    }
}

Node * delNode(Node * head,Node * delNode){
    Node * newHead = head;
    if(listLen(head) == 1){
        printf("only one node !");
    } else{
        Node * nextNode = head;
        while (1){
            if(nextNode->name == delNode->name){
                if(nextNode == head){
                    newHead = nextNode->next;
                }
                nextNode->prev->next = nextNode->next;
                nextNode->next->prev = nextNode->prev;
                free(nextNode);
                break;
            }
            nextNode=nextNode->next;
            if(nextNode == newHead){
                break;
            }
        }
    }
    return newHead;
}

void printList(Node * head){
    Node * nextNode = head;

    printf("name=%s,len=%d,prev=%p,address=%p,next=%p\n",nextNode->name,nextNode->len,nextNode->prev,nextNode,nextNode->next);
    while (nextNode->next != head){
        nextNode = nextNode->next;
        printf("name=%s,len=%d,prev=%p,address=%p,next=%p\n",nextNode->name,nextNode->len,nextNode->prev,nextNode,nextNode->next);
    }

}

int main(){
    Node * head = initNode();

    Node * node1 = create();
    strcpy(node1->name,"node1");
    addNode(head,node1);

    Node * node2 = create();
    strcpy(node2->name,"node2");
    addNode(head,node2);

    Node * node3 = create();
    strcpy(node3->name,"node3");
    addNode(head,node3);

    Node * node4 = create();
    strcpy(node4->name,"node4");
    addNode(head,node4);

    printList(head);

    printf("------------------------------\n");

    head = delNode(head,head);

    printList(head);

    return 0;

}






