#!/usr/bin/env bash

#脚本的重要说明：运行这个脚本需要使用的命令source create_ipfs_?.sh  要用source才行。

secret_master=`c14aba9e8f4f16f8bdad7c4e11033dd543ed68e0a380d181629d035275090ddf`	#加入到某个ipfs集群需要用到的secret值，群里的节点机都需要统一用一个secret值。这个值来自1.41真机HDD4T机器
userdir=`who|awk '{print $1}'|awk 'NR==1'`
local_ip=`ip addr | grep 'inet' | grep -v 'inet6\|127.0.0.1' | grep -v grep | awk -F '/' '{print $1}' | awk '{print $2}' | head -1`
echo -e "\e[40;31m 本机IP为:${local_ip} \e[0m"	#显示红色字体

cd /home/${userdir}
echo -e "\e[40;31m 获取准确的普通用户目录 \e[0m"	#显示红色字体
#echo -e "\e[40;34m 这个是显示蓝色字体的命令 \e[0m"
pwd  #显示出用了变量后的准确路径。
apt update
apt upgrade -y

echo -e "\e[40;31m 下载新的go包 \e[0m"
#wget https://dl.google.com/go/go1.18.3.linux-amd64.tar.gz
wget https://dl.google.com/go/go1.17.8.linux-amd64.tar.gz
echo "=========下载到的go软件包版本========"
ls go1.*

sudo tar -zxvf go1.17.8.linux-amd64.tar.gz  -C  /usr/local  >/dev/null 2>&1
ls /usr/local/go
echo "=========解压go包完成========"

cd /root
sudo mkdir -p go/{src,pkg,bin}
sudo chmod u+x go/{src,pkg,bin}
echo "=========新建好root/go目录========"

if grep "/usr/local/go/bin" /home/${userdir}/.profile
then
    echo "/usr/local/go/bin 已经存在不用写"
else
    echo '之前没有，需要添加语句'
    echo 'export PATH=$PATH:/usr/local/go/bin' >> /home/${userdir}/.profile
fi

if grep "export GOROOT" /home/${userdir}/.profile
then
   echo "GOROOT=/usr/local/go 已经存在不用写"
else
   echo '之前没有，需要添加语句'
   echo 'export GOROOT=/usr/local/go' >> /home/${userdir}/.profile
fi

if grep "export GOPATH" /home/${userdir}/.profile
then
	echo "GOPATH=$HOME/go 已经存在不用写"
else
	echo '之前没有，需要添加语句'
	echo 'export GOPATH=$HOME/go' >> /home/${userdir}/.profile
fi

if grep "HOME/go/bin" /home/${userdir}/.profile
then
   echo "export PATH 已经存在不用写"
else
   echo '之前没有，需要添加语句'
   echo 'export PATH=$PATH:$HOME/go/bin' >> /home/${userdir}/.profile
fi

<<AAA  #用了上面的if智能判断后已经不需要以下四行的固定添加语句了。
echo 'export PATH=$PATH:/usr/local/go/bin' >> /home/${userdir}/.profile
echo 'export GOROOT=/usr/local/go' >> /home/${userdir}/.profile
echo 'export GOPATH=$HOME/go' >> /home/${userdir}/.profile
echo 'export PATH=$PATH:$HOME/go/bin' >> /home/${userdir}/.profile
AAA

sleep 1
echo -e "\e[40;31m 运行source普通用户目录下的.profile \e[0m"
source /home/${userdir}/.profile
echo "=========看到go的版本与go配置信息========"
go version
go env
sleep 1


if grep "/usr/local/go/bin" /root/.bashrc
then
    echo "/usr/local/go/bin 已经存在不用写"
else
    echo '之前没有，需要添加语句'
    echo 'export PATH=$PATH:/usr/local/go/bin' >> /root/.bashrc
fi

if grep "export GOROOT" /root/.bashrc
then
   echo "GOROOT=/usr/local/go 已经存在不用写"
else
   echo '之前没有，需要添加语句'
   echo 'export GOROOT=/usr/local/go' >> /root/.bashrc
fi

if grep "export GOPATH" /root/.bashrc
then
	echo "GOPATH=$HOME/go 已经存在不用写"
else
	echo '之前没有，需要添加语句'
	echo 'export GOPATH=$HOME/go' >> /root/.bashrc
fi

if grep "HOME/go/bin" /root/.bashrc
then
   echo "export PATH 已经存在不用写"
else
   echo '之前没有，需要添加语句'
   echo 'export PATH=$PATH:$HOME/go/bin' >> /root/.bashrc
fi



echo -e "\e[40;31m 运行source命令激活root/.profile \e[0m"
source /root/.bashrc


echo "=========Go环境部署与配置完成。========"
sleep 1
echo "=========安装工具包。========"
#sudo apt update && apt upgrade -y
sudo apt-get install git
#sudo apt install gcc
sudo apt install gcc -y  #加了-y不用再手动输入y
sudo apt install make

echo "=========下载go-ipfs源码。========"
go env -w GO111MODULE=on
go env -w GOPROXY=https://goproxy.cn,direct
go get -u github.com/ipfs/go-ipfs

#cd  /root/go/pkg/mod/github.com/ipfs/go-ipfs@v0.12.0/
cd  /root/go/pkg/mod/github.com/ipfs/go-ipfs@v0.13.0/
##上面这一行命令的地址有待研究，会变的，不同时间下载的版本可能最后的地址会变。
chmod 777 bin/check_go_version 
chmod 777 plugin/loader/preload.sh
make install
ipfs version
echo "=========如出ipfs version 则部署成功========"

echo -e "\e[40;34m 禁用go的MOD \e[0m"
go env -w GO111MODULE=off
echo -e "\e[40;34m ipfs节点进行初始化 \e[0m"

ipfs init
sleep 1
ipfs init
cd /root/.ipfs/ 
echo -e "\e[40;34m /root/.ipfs/目录下的东西 \e[0m"
ls -l  

sed -i -e "s/127.0.0.1/${local_ip}/g"  /root/.ipfs/config
echo -e "\e[40;34m  把/root/.ipfs/config的两个本地IP改为实际IP了  \e[0m"
ipfs bootstrap rm --all




<<AAA
docker --version >/dev/null 2>&1
if [ $? -eq 0 ]
then
    echo "已安装docker"
else
    echo "正在安装docker-----------"
    apt install docker.io -y >/dev/null 2>&1
	echo "=======安装完成=========="
    sleep 5
fi

cur_dir=$(cd "$(dirname "$0")";pwd)
cd $cur_dir
IMAGE_NAME='mysql:8.0.13'
DOCKER_NAME='master'
MYSQL_PASSWORD='123456'
PORT='4306'
script='user_mysql.sh'
confdir='/usr/local/master/conf'
datadir='/usr/local/master/data'

#创建映射目录
[ ! -d $confdir ] && mkdir -p $confdir
[ ! -d $datadir ] && mkdir -p $datadir
[ ! -f $confdir/my.cnf ] && touch $confdir/my.cnf

#创建MySQL容器
create_mysql () {
	docker pull $IMAGE_NAME >/dev/null 2>&1
	docker run --name $DOCKER_NAME -p $PORT:3306 --restart always -v $confdir:/etc/mysql/conf.d/ -v $datadir:/var/lib/mysql -e MYSQL_ROOT_PASSWORD=$MYSQL_PASSWORD -d $IMAGE_NAME
}

#制作创建MySQL用户脚本
create_script () {
	echo '#!/usr/bin/env bash' >${script}
    echo "mysql -uroot -p$MYSQL_PASSWORD <<EOF" >>${script}
    echo "create user '$DOCKER_NAME'@'%' identified with mysql_native_password by '$MYSQL_PASSWORD';" >>${script}
    echo "grant replication slave,replication client on *.* TO '$DOCKER_NAME'@'%';" >>${script}
    echo 'flush privileges;' >>${script}
    echo 'EOF' >>${script}
}

#配置MySQL数据库
config_databases () {
	create_script
	chmod +x ${script}
	docker cp ${script} $DOCKER_NAME:/
	echo "正在复制脚本----------------------"
	sleep 15
	docker exec -it $DOCKER_NAME bash -c " ./${script}; "
}
	
#主函数
config_mysql () {
	cat >$confdir/my.cnf <<EOF
[mysqld]
# master01主服务器01唯一ID
server-id=$PORT

# 启用二进制日志
log-bin=mysql-bin

#从库的中继日志，主库日志写到中继日志，中继日志再重做到从库
# relay-log=myslql-relay-bin

# binlog保留时间7天
expire_logs_days=7

#指定不同步库
binlog-ignore-db=mysql
binlog-ignore-db=information_schema
binlog-ignore-db=performance_schema
binlog-ignore-db=sys
EOF
}

#重启docker容器使主函数生效
docker restart $DOCKER_NAME

main () {
	echo "=========正在创建MySQL容器========"
	create_mysql
	echo "========正在配置MySQL数据库======="
	config_databases
	echo "========正在导入数据库配置========"
	config_mysql
	echo "=================================="
	echo -e "\033[40;36m success \033[0m"
	echo "=================================="
}
main $@
AAA


